#include <linux/delay.h>
#include "dvlled_mod.h"

#include <asm/mach-atheros/atheros.h>

struct dvlled_entry global_leds[] = 
{
	//everything below: temporarily for hornet board bring-up
    //GPIONAME_DLAN_LEDS_ENABLE,GPIONAME_DLAN_SLEEP_INDIC,GPIONAME_DLAN_POWER_ONOFF are GPIOs with type LED!
	{ LEDNAME_WIFI_2G,    			TYPE_LED,	    0,   	0, POL_HA },
	{ GPIONAME_DLAN_LEDS_ENABLE,	TYPE_LED,   	18, 	0, POL_HA }, /*switch on/off dlan leds*/
	{ GPIONAME_DLAN_SLEEP_INDIC,	TYPE_LED,    	19,		0, POL_HA }, /*set 7420 in sleepmode (wakeup from)*/
	{ GPIONAME_DLAN_RESETLINE,		TYPE_LED,	    20,		0, POL_HA }, /*resetline of 7420*/
	{ GPIONAME_DLAN_POWER_ONOFF,	TYPE_LED,   	22,		0, POL_HA }, /*switch power on/off of 7420 (MOSFET)*/
	{ GPIONAME_DLAN_PAIRING,        TYPE_LED,       23,     0, POL_HA }, /*pairing "btn" of powerline adapter*/

#if 0
	{ LEDNAME_DLAN_SLEEP,       	TYPE_LED,  		-1, -1, POL_HA },
#endif
	
	{ "", TYPE_NONE, 0, 0, 0 }
};

int lan_led_idx = 3; //index of the gpio entry in the global_leds array that represents the lan activity led
int wireless_2g_led_idx = 1; //index of the gpio entry in the global_leds array that represents the wireless 2g activity led
int wireless_5g_led_idx = 0; //index of the gpio entry in the global_leds array that represents the wireless 5g activity led

#define GPIO_DIR_OUT 1
#define GPIO_DIR_IN  0

// we should take these values from an Atheros header if this is possible in a later SDK release
#define REG_GPIO_OE            ATH_GPIO_OE
#define REG_GPIO_IN            ATH_GPIO_IN
#define REG_GPIO_OUT           ATH_GPIO_OUT
#define REG_GPIO_SET           ATH_GPIO_SET
#define REG_GPIO_CLEAR         ATH_GPIO_CLEAR
#define REG_GPIO_INT           ATH_GPIO_INT_ENABLE
#define REG_GPIO_INT_TYPE      ATH_GPIO_INT_TYPE
#define REG_GPIO_INT_POLARITY  ATH_GPIO_INT_POLARITY
#define REG_GPIO_INT_PENDING   ATH_GPIO_INT_PENDING
#define REG_GPIO_INT_MASK      ATH_GPIO_INT_MASK
#define REG_GPIO_OUT_FUNC1     ATH_GPIO_OUT_FUNCTION1
#define REG_GPIO_OUT_FUNC2     ATH_GPIO_OUT_FUNCTION2

static int gpio_func_unmapped = 0;

static void dvl_gpio_line_config(int line, int direction)
{
	uint32_t tmp, tmp2;

	if (gpio_func_unmapped == 0 && (line == 0 || line == 18))
    {
		//disable the first WLAN LED function on GPIO0
		//so it can be controlled by software
		printk("### unmapping function for GPIO0 (WIFI_2G)\n");
	    ath_reg_wr (REG_GPIO_OUT_FUNC2, (ath_reg_rd(REG_GPIO_OUT_FUNC2) & ~(0x1<<10)));

	    printk("### unmapping function for GPIO18 (DLAN_LEDS_ENABLE)\n");
	    ath_reg_wr (REG_GPIO_OUT_FUNC1, (ath_reg_rd(REG_GPIO_OUT_FUNC1) & ~(0x1<<29))); //I²S is mapped to GPIO 6-12
	    ath_reg_wr (REG_GPIO_OUT_FUNC1, (ath_reg_rd(REG_GPIO_OUT_FUNC1) & ~(0x1<<26))); //disable I²S on GPIOs

        gpio_func_unmapped = 1;
    }

	// direction
	tmp = ath_reg_rd(REG_GPIO_OE);
	if (direction == GPIO_DIR_OUT)
	{
		tmp |= (uint32_t)(1 << line);
	}
	else if (direction == GPIO_DIR_IN)
	{
		tmp &= ~(uint32_t)(1 << line);
	}

	printk("configuring gpio %d as output\n", line);
	ath_reg_wr(REG_GPIO_OE, tmp);
}

static void dvl_gpio_line_set(int line, int value)
{
	uint32_t tmp = 0;
	if (value)
	{
		ath_reg_wr(REG_GPIO_SET, (uint32_t)(1 << line));
	}
	else
	{
		ath_reg_wr(REG_GPIO_CLEAR, (uint32_t)(1 << line));
	}
}

//
//
//

void dvl_led_config_out(int line)
{
	dvl_gpio_line_config(line, GPIO_DIR_OUT);
}

void dvl_led_set(int line, int value)
{
	dvl_gpio_line_set(line, value);
}

void dvl_led_probe(struct platform_device *pdev)
{
}

void dvl_led_remove(struct platform_device *pdev)
{
}

void dvl_led_init(void)
{
}

