
#include "dvlbutton_mod.h"

#include <asm/mach-atheros/atheros.h>
#include <asm/mach-atheros/933x.h>

//Choose GPIOs
#define AR9331_RESET_FACTORY_GPIO 	11
#define AR9331_WIFI_WPS_GPIO 		21
#define AR9331_DLAN_PAIRING_GPIO	12

//Take also care of POL_AH || POL_AL

dvlbutton_entry_t global_buttons[] =
{
	//Here the wps pairing button has a second function, -> wifi on/off
	//configure Button to DVLBUTTON_NONE to indicate that configuration is only valid if set by middleware
    //! result: on startup the button has no functionality until the button is configured by middleware
    { BUTTONNAME_WPS,                 TYPE_BUTTON_SHORTLONG, NO_MULTI_CONNECTION,    DVLBUTTON_NONE,         	DVLBUTTON_NONE,               DVLBUTTON_NONE,		        AR9331_WIFI_WPS_GPIO, 		ATH_GPIO_IRQ_BASE+AR9331_WIFI_WPS_GPIO, 		POL_HA,    SENSE_EDGE,   1000,  3000,  0 },

	{ BUTTONNAME_RESET_FACTORY,       TYPE_BUTTON_SHORTLONG, NO_MULTI_CONNECTION,    DVLBUTTON_RESET,			DVLBUTTON_FACTORYDEFAULT,     DVLBUTTON_NONE,               AR9331_RESET_FACTORY_GPIO, 	ATH_GPIO_IRQ_BASE+AR9331_RESET_FACTORY_GPIO,	POL_HA,    SENSE_EDGE,   1000,  5000,  0 },

	{ BUTTONNAME_DLAN_PAIRING_RANDOM, TYPE_BUTTON_SHORTLONG, NO_MULTI_CONNECTION,    DVLBUTTON_DLAN_PAIRING,	DVLBUTTON_DLAN_RANDOM,        DVLBUTTON_NONE,               AR9331_DLAN_PAIRING_GPIO, 	ATH_GPIO_IRQ_BASE+AR9331_DLAN_PAIRING_GPIO, 	POL_HA,    SENSE_EDGE,   3000,  10000,  0 },

	// This board does not have coax, so we provide a fake switch which always states that PL is active.
	{ BUTTONNAME_PL_CL,               TYPE_SWITCH,           NO_MULTI_CONNECTION,    DVLBUTTON_DLAN_PL,         DVLBUTTON_DLAN_PL,            DVLBUTTON_NONE,               -1,                   -1,   POL_UNDEF, SENSE_EDGE,      0,     0,     0 },
	
	{ "", TYPE_NONE, NO_MULTI_CONNECTION, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
};


#ifdef _DVL_ENABLE_BUTTON_MAPPING
//depends on platform, contains all valid characters
char valid_button_char[] = {DVLBUTTON_WPS, DVLBUTTON_WIFI_ON_OFF, NULL}; //close array with NULL

//depends on platform, only these buttons are accessible
char *valid_buttons[] = {BUTTONNAME_WPS, NULL};
#endif

#define GPIO_DIR_OUT 1
#define GPIO_DIR_IN  0

#define REG_GPIO_OE            ATH_GPIO_OE
#define REG_GPIO_IN            ATH_GPIO_IN
#define REG_GPIO_OUT           ATH_GPIO_OUT
#define REG_GPIO_SET           ATH_GPIO_SET
#define REG_GPIO_CLEAR         ATH_GPIO_CLEAR
#define REG_GPIO_INT           ATH_GPIO_INT_ENABLE
#define REG_GPIO_INT_TYPE      ATH_GPIO_INT_TYPE
#define REG_GPIO_INT_POLARITY  ATH_GPIO_INT_POLARITY
#define REG_GPIO_INT_PENDING   ATH_GPIO_INT_PENDING
#define REG_GPIO_INT_MASK      ATH_GPIO_INT_MASK

static void dvl_gpio_line_config(dvlbutton_entry_t *button)
{
	uint32_t tmp;

	// polarity (high/low active): set this before(!) configuring interrupt-type to avoid instant interrupt activation
	tmp = ath_reg_rd(REG_GPIO_INT_POLARITY);
	if (button->polarity == POL_LA)
	{
		tmp &= ~(uint32_t)(1 << button->gpio);
	}
	else
	{
		tmp |= (uint32_t)(1 << button->gpio);
	}
	ath_reg_wr(REG_GPIO_INT_POLARITY, tmp);


	// sensitivity (edge or level)
	tmp = ath_reg_rd(REG_GPIO_INT_TYPE);
	if (button->sensitivity == SENSE_EDGE)
	{
	    tmp |= (uint32_t)(1 << button->gpio); //level sensitive
	}
	else if (button->sensitivity == SENSE_LEVEL)
	{
	    tmp &= ~(uint32_t)(1 << button->gpio); //edge sensitive
	}
	ath_reg_wr(REG_GPIO_INT_TYPE, tmp);

	// direction (do this once again here to be sure that settings are correct. should already have been configured by bootloader)
	tmp = ath_reg_rd(REG_GPIO_OE);
	tmp &= ~(uint32_t)(1 << button->gpio);
	ath_reg_wr(REG_GPIO_OE, tmp);

	//arm the according interrupt, if configured properly
    if (button->type != TYPE_NONE)
    {
        if (button->gpio >= 0 && button->gpio <= 22)
        {
            ath_reg_wr(REG_GPIO_INT,      (ath_reg_rd(REG_GPIO_INT) | (1 << button->gpio)));
            ath_reg_wr(REG_GPIO_INT_MASK, (ath_reg_rd(REG_GPIO_INT_MASK) | (1 << button->gpio)));
        }
    }
}

void dvl_gpio_line_get(int line, int *value)
{
	uint32_t tmp;

	tmp = ath_reg_rd(REG_GPIO_IN);
	tmp &= (1 << line);
	*value = (int) (tmp >> line);
}

//
//
//

void dvl_gpio_line_config_in(dvlbutton_entry_t *button)
{
	dvl_gpio_line_config(button);
}

void dvl_gpio_change_get(int irq, int *button, int *change)
{
	dvlbutton_entry_t *b;
	int i;

	uint32_t lines = ath_reg_rd(REG_GPIO_IN);
	uint32_t pol   = ath_reg_rd(REG_GPIO_INT_POLARITY);
	uint32_t type  = ath_reg_rd(REG_GPIO_INT_TYPE);

	*button = -1;

	for (b = global_buttons, i = 0; b->type != TYPE_NONE; b++, i++)
	{
		if (b->irq == irq)
		{
			*button = i;
			*change = (lines >> b->gpio) & 1;

			if ((type & (1 << b->gpio)) != 0) //only change polarity on level sensitive interrupts, as edge sensitives trigger on both edges, though datasheets states differently
			{
				if (*change != 0)
					pol &= ~(uint32_t)(1 << b->gpio);
				else
					pol |= (uint32_t)(1 << b->gpio);

				ath_reg_wr(REG_GPIO_INT_POLARITY, pol);
			}
		}
	}
}

void dvl_gpio_clear(void)
{
    //clear all pending interrupts
	(void) ath_reg_rd(REG_GPIO_INT_PENDING);
	ath_reg_wr(REG_GPIO_INT_PENDING, 0);
}

void dvl_gpio_init(void)
{
    //clear and disable all gpio interrupts
    (void) ath_reg_rd(REG_GPIO_INT_PENDING);
    ath_reg_wr(REG_GPIO_INT_PENDING, 0);
    ath_reg_wr(REG_GPIO_INT,      0);
    ath_reg_wr(REG_GPIO_INT_MASK, 0);
}

void dvl_gpio_shutdown(void)
{
    //not implemented
}

