#include <linux/delay.h>
#include "dvlled_mod.h"

#include <asm/mach-ath79/ar71xx_regs.h>
#include <asm/mach-ath79/ath79.h>
#include <asm/mach-ath79/irq.h>

#include <linux/io.h>

struct dvlled_entry global_leds[] = 
{
  //{ char *name,                   int type,	        int line1,	int line2,	    polarity_t polarity },
  //{ char *name,                   TYPE_LED,	        ledGpio,	unused,	        polarity_t polarity },
  //{ char *name,                   TYPE_MIRRORED_LED,  ledGpio,	mirroredGpio,	polarity_t polarity },
	{ LEDNAME_WIFI_WHITE,		    TYPE_LED,	        12,   	    0,              POL_LA }, /*common wifi led (white), 2g/5g*/
	{ GPIONAME_DLAN_POWER_ONOFF,	TYPE_LED,   	    13,		    0,              POL_HA }, /*switch 7450 power on/off via MOSFET*/
	{ LEDNAME_DLAN_WHITE,	        TYPE_MIRRORED_LED,  14,		    17,             POL_LA }, /*plc quality indicator led white*/
	{ LEDNAME_DLAN_RED,	            TYPE_MIRRORED_LED, 	15,		    16,             POL_HA }, /*plc quality indicator led red*/
	{ GPIONAME_WIFI_POWER_ONOFF,	TYPE_LED,   	    21,		    0,              POL_HA }, /*switch Peregrine power on/off via MOSFET*/
	{ "", TYPE_NONE, 0, 0, 0 }
};

int lan_led_idx = 3; //index of the gpio entry in the global_leds array that represents the lan activity led
int wireless_2g_led_idx = 1; //index of the gpio entry in the global_leds array that represents the wireless 2g activity led
int wireless_5g_led_idx = 0; //index of the gpio entry in the global_leds array that represents the wireless 5g activity led

#define GPIO_DIR_OUT 1
#define GPIO_DIR_IN  0

// we should take these values from an Atheros header if this is possible in a later SDK release
#define REG_GPIO_OE            AR71XX_GPIO_REG_OE
#define REG_GPIO_IN            AR71XX_GPIO_REG_IN
#define REG_GPIO_OUT           AR71XX_GPIO_REG_OUT
#define REG_GPIO_SET           AR71XX_GPIO_REG_SET
#define REG_GPIO_CLEAR         AR71XX_GPIO_REG_CLEAR
#define REG_GPIO_INT           AR71XX_GPIO_REG_INT_MODE
#define REG_GPIO_INT_TYPE      AR71XX_GPIO_REG_INT_TYPE
#define REG_GPIO_INT_POLARITY  AR71XX_GPIO_REG_INT_POLARITY
#define REG_GPIO_INT_PENDING   AR71XX_GPIO_REG_INT_PENDING
#define REG_GPIO_INT_MASK      AR71XX_GPIO_REG_INT_ENABLE

//make some defines for compability (see, older atheros sources)
//for "normal usage" refer examples in: asm/mach-ath79/ath79.h
#define ath_reg_rd(REGISTER) __raw_readl(ioremap_nocache(AR71XX_GPIO_BASE, AR71XX_GPIO_SIZE) + REGISTER)
#define ath_reg_wr(REGISTER,VALUE) __raw_writel(VALUE,ioremap_nocache(AR71XX_GPIO_BASE, AR71XX_GPIO_SIZE) + REGISTER)

static void dvl_gpio_line_config(int line, int direction)
{
	uint32_t tmp;

	// direction
	tmp = ath_reg_rd(REG_GPIO_OE);
	if (direction == GPIO_DIR_OUT)
		tmp &= ~(uint32_t)(1 << line);
	else if (direction == GPIO_DIR_IN)
		tmp |= (uint32_t)(1 << line);

	printk("configuring gpio %d as output\n", line);
	ath_reg_wr(REG_GPIO_OE, tmp);
}

static void dvl_gpio_line_set(int line, int value)
{
	if (value)
	{
		ath_reg_wr(REG_GPIO_SET, (uint32_t)(1 << line));
	}
	else
	{
		ath_reg_wr(REG_GPIO_CLEAR, (uint32_t)(1 << line));
	}
}

//
//
//

void dvl_led_config_out(int line)
{
	dvl_gpio_line_config(line, GPIO_DIR_OUT);
}

void dvl_led_set(int line, int value)
{
	dvl_gpio_line_set(line, value);
}

int dvl_led_get(const int gpio)
{
    uint32_t allOut = ath_reg_rd(REG_GPIO_OUT);
    
    //mask with gpio and shift
    return ((allOut & (1 << gpio)) >> gpio);
}

void dvl_led_probe(struct platform_device *pdev)
{
}

void dvl_led_remove(struct platform_device *pdev)
{
}

void dvl_led_init(void)
{
}

