/*
 * Copyright (c) 2013 Qualcomm Atheros, Inc.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */
 
#include <common.h>
#include <config.h>
#include <asm/types.h>
#include <flash.h>

#ifndef CONFIG_ATH_NAND_BR
/*
 * sets up flash_info and returns size of FLASH (bytes)
 */
unsigned long
flash_get_geom (flash_info_t *flash_info)
{
	int i;

	/* XXX this is hardcoded until we figure out how to read flash id */

	flash_info->flash_id = FLASH_M25P64;
	flash_info->size = CFG_FLASH_SIZE; /* bytes */
	flash_info->sector_count = flash_info->size / CFG_FLASH_SECTOR_SIZE;

	for (i = 0; i < flash_info->sector_count; i++) {
		flash_info->start[i] = CFG_FLASH_BASE +
					(i * CFG_FLASH_SECTOR_SIZE);
		flash_info->protect[i] = 0;
	}

	printf ("flash size %dMB, sector count = %d\n",
			FLASH_SIZE, flash_info->sector_count);

	return (flash_info->size);
}
#endif /* CONFIG_ATH_NAND_BR */
