#include <asm/ioctl.h>

#include <dvl_features.h>

/* Use 0xCE as magic number */
#define DVLBUTTON_IOC_MAGIC 0xCE

#define DVLBUTTON_IOCRESET       _IO(DVLBUTTON_IOC_MAGIC, 0)
#define DVLBUTTON_IOCGBTNSTATE   _IOWR(DVLBUTTON_IOC_MAGIC, 1, int)

#define DVLBUTTON_NONE                    ' '

#define DVLBUTTON_RESET                   'R'
#define DVLBUTTON_FACTORYDEFAULT          'F'
#define DVLBUTTON_WIFI_ON_OFF             'O'
#define DVLBUTTON_WPS                     'W'
#define DVLBUTTON_DLAN_PL                 'P'
#define DVLBUTTON_DLAN_CL                 'C'
#define DVLBUTTON_DLAN_PAIRING            'D'
#define DVLBUTTON_DLAN_RANDOM             'E'
#define DVLBUTTON_DLAN_POWER_LED_ON       'H' //indication that state of the plc power led is on (on some products not a real led)
#define DVLBUTTON_DLAN_POWER_LED_OFF      'L' //indication that state of the plc power led is off (on some products not a real led)
#define DVLBUTTON_ETH_LINK_ON             'A'
#define DVLBUTTON_ETH_LINK_OFF            'B'

#define DVLBUTTON_HOMECONTROL_PAIRING     'G'
#define DVLBUTTON_HC_FACTORY_RESET        'I'

#define BUTTONNAME_RESET_FACTORY          "reset_factory"
#define BUTTONNAME_WPS                    "wifi_wps"
#define BUTTONNAME_WIFI_ON_OFF            "wifi_on_off"
#define BUTTONNAME_DLAN_PAIRING_RANDOM    "dlan_pairing_random"

#define BUTTONNAME_DLAN_POWER_LED         "dlan_power_led"

#define BUTTONNAME_PL_CL                  "pl_cl"

#define BUTTONNAME_ETHERNET_LINK          "ethernet_link"
#define BUTTONNAME_HOMECONTROL_PAIRING    "homecontrol_pairing"

