#include <linux/kernel.h>
#include <linux/netdevice.h>
#include <dvl_features.h>

#include "dvltrafin_mod.h"
#include "athrs_phy_ctrl.h"

//####################################
//external prototypes


//####################################
//external variables
extern int devolo_currentWirelessBand; //in module umac included in package.ar934x-wifi


//####################################
//local variables
#ifndef _DVL_CLASSIC_LED_BLINK_FREQ
	static const unsigned int cTrafficIntensityLow = 10;
	static const unsigned int cTrafficIntensityMedium = 50;
	static const unsigned int cTrafficIntensityHigh = 100;
#endif

static int lastWirelessTxCounter = 0;
static struct net_device *wireless_dev = 0;
static char *device_name = 0;

//####################################
//local prototypes
static BOOL get_wireless_device(void);


//####################################
//local function definitions

BOOL connection_active(void)
{
	unsigned short flags = dev_get_flags(wireless_dev);

	return (flags & IFF_UP)?TRUE:FALSE;
}

wireless_band_t get_wireless_band(void)
{
	wireless_band_t band = eWBAND_2G; //default to 2.4GHz band

	if (devolo_currentWirelessBand > 0)
	{
		band = eWBAND_5G;
	}

	return band;
}

traffic_intensity_t get_traffic_intensity()
{
	unsigned int rv = eTRAFFIC_NONE;
	const struct net_device_stats *stats;
	unsigned int txCounter;

	if (wireless_dev == 0)
	{
	    if (get_wireless_device() == FALSE)
	        return rv;
	}

	stats = dev_get_stats(wireless_dev);
	txCounter = stats->tx_packets;

	txCounter -= lastWirelessTxCounter; //only consider tx since last check

	//return accordant traffic intensity category
#ifndef _DVL_CLASSIC_LED_BLINK_FREQ

	if (txCounter <= cTrafficIntensityLow)
	{
		rv = eTRAFFIC_NONE;
	}
	else if (txCounter > cTrafficIntensityLow && txCounter <= cTrafficIntensityMedium)
	{
		rv = eTRAFFIC_MEDIUM;
	}
	else if (txCounter > cTrafficIntensityHigh)
	{
		rv = eTRAFFIC_HIGH;
	}

#else
	if (txCounter > 0)
	{
		rv = eTRAFFIC_HIGH;
	}
	else
	{
		rv = eTRAFFIC_NONE;
	}

#endif

	lastWirelessTxCounter += txCounter;

	return rv;
}

static BOOL get_wireless_device()
{
	struct net_device *dev;
	char *devname = 0;
	char default_devname[] = "wifi0";

	if (device_name != 0)
	{
	    devname = device_name;
	}
	else
	{
	    devname = default_devname;
	}

	dev = first_net_device(&init_net);

	while (dev) {
	    if (strcmp(dev->name, devname) == 0)
	    {
			wireless_dev = dev;

			printk(KERN_INFO "dvltrafin_wifi: Using wireless interface %s!\n", devname);

	    	return TRUE;
	    }
	    dev = next_net_device(dev);
	}

	printk(KERN_ERR "dvltrafin_wifi: Could not find wireless interface %s!\n", devname);

	return FALSE; //no matching device found
}

BOOL switchctrl_load(char *devname)
{
	BOOL rv = TRUE;

	device_name = devname;

	rv = get_wireless_device();

	return rv;
}

BOOL switchctrl_unload(void)
{
	return TRUE;
}

