#ifndef DVLTRAFIN_MOD_H
#define DVLTRAFIN_MOD_H

#define TRUE 1
#define FALSE 0
typedef int BOOL;

typedef enum {
	eTRAFFIC_NONE = 0, //has to be zero!
	eTRAFFIC_LOW,
	eTRAFFIC_MEDIUM,
	eTRAFFIC_HIGH
} traffic_intensity_t;

#ifdef MAKE_WIFI
    typedef enum {
        eWBAND_2G,
        eWBAND_5G
    } wireless_band_t;
#endif

BOOL switchctrl_load(char *devname);
BOOL switchctrl_unload(void);
BOOL connection_active(void);
traffic_intensity_t get_traffic_intensity(void);

#if defined(MAKE_ETH)
    void set_lan_led(unsigned int on); //in module dvlled
#elif defined(MAKE_WIFI)
    wireless_band_t get_wireless_band(void);
    void set_wireless_2g_led(unsigned int on); //in module dvlled
    void set_wireless_5g_led(unsigned int on); //in module dvlled
#endif

#endif //DVLTRAFIN_MOD_H
