#include <common.h>
#include <command.h>
#include <asm/mipsregs.h>
#include <asm/addrspace.h>
#include <config.h>
#include <version.h>
#include "ar7240_soc.h"
#include "memtest.h"

#define CONFIG_POST CFG_POST_MEMORY
#include <post.h>

extern int wasp_ddr_initial_config(uint32_t refresh);
extern int ar7240_ddr_find_size(void);
extern int memory_post_test (int flags);

#ifdef COMPRESSED_UBOOT
#	define prmsg(...)
#	define args		char *s
#	define board_str(a)	strcpy(s, a)
#else
#	define prmsg		printf
#	define args		void
#	define board_str(a)	printf(a)
#endif

void
wasp_usb_initial_config(void)
{
#define unset(a)	(~(a))

	if ((ar7240_reg_rd(WASP_BOOTSTRAP_REG) & WASP_REF_CLK_25) == 0) {
		ar7240_reg_wr_nf(AR934X_SWITCH_CLOCK_SPARE,
			ar7240_reg_rd(AR934X_SWITCH_CLOCK_SPARE) |
			SWITCH_CLOCK_SPARE_USB_REFCLK_FREQ_SEL_SET(2));
	} else {
		ar7240_reg_wr_nf(AR934X_SWITCH_CLOCK_SPARE,
			ar7240_reg_rd(AR934X_SWITCH_CLOCK_SPARE) |
			SWITCH_CLOCK_SPARE_USB_REFCLK_FREQ_SEL_SET(5));
	}

	udelay(1000);
	ar7240_reg_wr(AR7240_RESET,
		ar7240_reg_rd(AR7240_RESET) |
		RST_RESET_USB_PHY_SUSPEND_OVERRIDE_SET(1));
	udelay(1000);
	ar7240_reg_wr(AR7240_RESET,
		ar7240_reg_rd(AR7240_RESET) &
		unset(RST_RESET_USB_PHY_RESET_SET(1)));
	udelay(1000);
	ar7240_reg_wr(AR7240_RESET,
		ar7240_reg_rd(AR7240_RESET) &
		unset(RST_RESET_USB_PHY_ARESET_SET(1)));
	udelay(1000);
	ar7240_reg_wr(AR7240_RESET,
		ar7240_reg_rd(AR7240_RESET) &
		unset(RST_RESET_USB_HOST_RESET_SET(1)));
	udelay(1000);
	if ((ar7240_reg_rd(AR7240_REV_ID) & 0xf) == 0) {
		/* Only for WASP 1.0 */
		ar7240_reg_wr(0xb8116c84 ,
			ar7240_reg_rd(0xb8116c84) & unset(1<<20));
	}
}

void ath_set_tuning_caps(void)
{
	typedef struct {
		u_int8_t	pad[0x28],
				params_for_tuning_caps[2],
				featureEnable;
	} __attribute__((__packed__)) ar9300_eeprom_t;

	ar9300_eeprom_t	*eep = (ar9300_eeprom_t *)WLANCAL;
	uint32_t	val;


	val = 0;
	/* checking feature enable bit 6 and caldata is valid */
	if ((eep->featureEnable & 0x40) && (eep->pad[0x0] != 0xff)) {
		/* xtal_capin -bit 17:23 and xtag_capout -bit 24:30*/
		val = (eep->params_for_tuning_caps[0] & 0x7f) << 17;
		val |= (eep->params_for_tuning_caps[0] & 0x7f) << 24;
	} else {
		/* default when no caldata available*/
		/* checking clock in bit 4 */
		if (ar7240_reg_rd(RST_BOOTSTRAP_ADDRESS) & 0x10) {
			val = (0x1020 << 17);  /*default 0x2040 for 40Mhz clock*/
		} else {
			val = (0x2040 << 17); /*default 0x4080 for 25Mhz clock*/
		}
	}
	val |= (ar7240_reg_rd(XTAL_ADDRESS) & (((1 << 17) - 1) | (1 << 31)));
	ar7240_reg_wr(XTAL_ADDRESS, val);
	prmsg("Setting 0xb8116290 to 0x%x\n", val);
	return;
}

void wasp_gpio_config(void)
{
	int gpio_inout_map, gpio_low_map, gpio_high_map, temp;

#if 0
	/* Disable clock obs */
	ar7240_reg_wr (AR7240_GPIO_FUNC, (ar7240_reg_rd(AR7240_GPIO_FUNC) & 0xffe7e0ff));
	/* Enable eth Switch LEDs */
#ifdef CONFIG_K31
	ar7240_reg_wr (AR7240_GPIO_FUNC, (ar7240_reg_rd(AR7240_GPIO_FUNC) | 0xd8));
#else
	ar7240_reg_wr (AR7240_GPIO_FUNC, (ar7240_reg_rd(AR7240_GPIO_FUNC) | 0xfa));
#endif
#endif

	//###devolo: set input and output gpios
	printf("setting in and out gpios\n");
	printf("  previous setting was: 0x%08x\n", ar7240_reg_rd(AR7240_GPIO_OE));

	gpio_inout_map = 0x0; //this would set all gpios as output
	gpio_inout_map |= (1 << 4); //set gpio 4 as input for reset button
	gpio_inout_map |= (1 << 8); //set gpio 8 as input for spi data
	gpio_inout_map |= (1 << 9); //set gpio 9 as input for uart0 data
	gpio_inout_map |= (1 << 15); //set gpio 15 as input for plc-power-led-status
	gpio_inout_map |= (1 << 20); //set gpio 20 as input for wifi button
	gpio_inout_map |= (1 << 21); //set gpio 21 as input for wps button
	gpio_inout_map |= (1 << 22); //set gpio 22 as input for pairing button

#if 0
	//set all explicitly used gpios and leave other ones at their default
	gpio_inout_map = ar7240_reg_rd(AR7240_GPIO_OE);
	gpio_inout_map |= (1 << 4); //set gpio 4 as input for reset button
	gpio_inout_map |= (1 << 8); //set gpio 8 as input for spi data
	gpio_inout_map |= (1 << 9); //set gpio 9 as input for uart0 data
	gpio_inout_map |= (1 << 15); //set gpio 15 as input for plc-power-led-status
	gpio_inout_map |= (1 << 20); //set gpio 20 as input for wifi button
	gpio_inout_map |= (1 << 21); //set gpio 21 as input for wps button
	gpio_inout_map |= (1 << 22); //set gpio 22 as input for pairing button
	gpio_inout_map &= ~(1 << 11);
	gpio_inout_map &= ~(1 << 12);
	gpio_inout_map &= ~(1 << 16);
	gpio_inout_map &= ~(1 << 14);
	//gpio_inout_map &= ~(1 << 13); //do not touch gpio 13 for hardware debug reasons
	gpio_inout_map &= ~(1 << 17);
	gpio_inout_map &= ~(1 << 18);
	gpio_inout_map &= ~(1 << 19);
#endif

	printf("  new setting will be: 0x%08x\n", gpio_inout_map);
	ar7240_reg_wr(AR7240_GPIO_OE, gpio_inout_map); //set desired in/out settings

	gpio_low_map = 0x0; //map of all gpios set to low state (does not necessarily mean off!)
	gpio_high_map = 0x0; //map of all gpios set to high state (does not necessarily mean on!)
	gpio_high_map |= (1 << 11); //wifi 5g led off
	gpio_high_map |= (1 << 12); //wifi 2g led off
	gpio_low_map |= (1 << 13); //plc power off
	gpio_high_map |= (1 << 14); //ethernet led off
	gpio_low_map |= (1 << 16); //power led on
	gpio_high_map |= (1 << 17); //plc led enable on
	printf("setting output gpio states (set 0x%08x, clear 0x%08x)\n", gpio_low_map, gpio_high_map);
	ar7240_reg_wr(AR7240_GPIO_SET, gpio_high_map);
	ar7240_reg_wr(AR7240_GPIO_CLEAR, gpio_low_map);

	printf("setting gpio OUT function mappings\n");
	ar7240_reg_wr(AR7240_GPIO_OUT_FUNCTION0, 0x00000000);
	ar7240_reg_wr(AR7240_GPIO_OUT_FUNCTION1, 0x0b0a0900); //set gpio 5 to spi_cs_0, 6 to spi_clk and 7 to spi_mosi
	ar7240_reg_wr(AR7240_GPIO_OUT_FUNCTION2, 0x00180000); //set gpio 10 to uart0_sout
	ar7240_reg_wr(AR7240_GPIO_OUT_FUNCTION3, 0x00000000);
//	temp = ar7240_reg_rd(AR7240_GPIO_OUT_FUNCTION4);
//	temp |= 0x2f2e0000; //set gpio 18 and 19 to lna control and leave 16 untouched
//	temp &= 0xFFFF00FF; //clear function mapping for gpio 17
//	ar7240_reg_wr(AR7240_GPIO_OUT_FUNCTION4, temp);
	ar7240_reg_wr(AR7240_GPIO_OUT_FUNCTION4, 0x2f2e0000); //set gpio 18 and 19 to lna control
	temp = ar7240_reg_rd(AR7240_GPIO_OUT_FUNCTION5);
	temp &= 0xFF000000; //clear function mapping for gpios 20, 21 and 22
	ar7240_reg_wr(AR7240_GPIO_OUT_FUNCTION5, temp);

	printf("setting gpio IN function mappings\n");
	ar7240_reg_wr(AR7240_GPIO_IN_ENABLE0, 0x00000908); //set gpio 9 to uart0_sin and gpio 8 to spi_miso (do it although it's the default)
	ar7240_reg_wr(AR7240_GPIO_IN_ENABLE1, 0x00000000);
	ar7240_reg_wr(AR7240_GPIO_IN_ENABLE2, 0x00000000);
	ar7240_reg_wr(AR7240_GPIO_IN_ENABLE3, 0x00000000);
	ar7240_reg_wr(AR7240_GPIO_IN_ENABLE4, 0x00000000);
	ar7240_reg_wr(AR7240_GPIO_IN_ENABLE9, 0x00000000);

	printf("clearing and disabling all gpio interrupts\n");
	(void) ar7240_reg_rd(AR7240_GPIO_INT_PENDING);
	ar7240_reg_wr(AR7240_GPIO_INT_PENDING, 0);
	ar7240_reg_wr(AR7240_GPIO_INT_ENABLE, 0);
	ar7240_reg_wr(AR7240_GPIO_INT_MASK, 0);
}

int
wasp_mem_config(void)
{
	extern void ath_ddr_tap_cal(void);
	unsigned int type, reg32;
	printf("\n");
	printf("######################################\n");
#if defined (DVL_CONFIG_TFTP_AUTOUPDATE)
	printf("ga_v3_autoupdate\n");
#else
	printf("ga_v3\n");
#endif
	printf("######################################\n");

	type = wasp_ddr_initial_config(CFG_DDR_REFRESH_VAL);

	ath_ddr_tap_cal();

	prmsg("Tap value selected = 0x%x [0x%x - 0x%x]\n",
		ar7240_reg_rd(AR7240_DDR_TAP_CONTROL0),
		ar7240_reg_rd(0xbd007f10), ar7240_reg_rd(0xbd007f14));

	/* Take WMAC out of reset */
	reg32 = ar7240_reg_rd(AR7240_RESET);
	reg32 = reg32 &  ~AR7240_RESET_WMAC;
	ar7240_reg_wr_nf(AR7240_RESET, reg32);

#if !defined(CONFIG_ATH_NAND_BR)
	/* Switching regulator settings */
	ar7240_reg_wr_nf(0x18116c40, 0x633c8176); /* AR_PHY_PMU1 */
	ar7240_reg_wr_nf(0x18116c44, 0x10380000); /* AR_PHY_PMU2 */

	wasp_usb_initial_config();

#endif /* !defined(CONFIG_ATH_NAND_BR) */

	wasp_gpio_config();
#if 0 //de-/activate memtest
	//devolo: activate wifi 2g and 5g leds as memtest indicator
	ar7240_reg_wr (AR7240_GPIO_CLEAR, (1 << 12));
	ar7240_reg_wr (AR7240_GPIO_CLEAR, (1 << 11));

	//devolo: test the whole ram
	//if (memory_post_test(POST_SLOWTEST) != 0) //very extensive memory test, taken from u-boot post

	//devolo: very simple memtest
	if (run_memtest((datum_t *)CFG_MEMTEST_START, ((CFG_MEMTEST_END) - (CFG_MEMTEST_START))) != 0)
	{
		ar7240_reg_wr (AR7240_GPIO_SET, (1 << 16)); //deactivate power led as error indication
		//return -1;
	}

	//devolo: deactivate wifi 2g and 5g leds
	ar7240_reg_wr (AR7240_GPIO_SET, (1 << 11));
	ar7240_reg_wr (AR7240_GPIO_SET, (1 << 12));
#endif
	ath_set_tuning_caps(); /* Needed here not to mess with Ethernet clocks */ 

	reg32 = ar7240_ddr_find_size();

	return reg32;
}

long int initdram(int board_type)
{
	return wasp_mem_config();
}

int	checkboard(args)
{
#if CONFIG_AP123
	board_str("U-boot AP123\n");
#elif CONFIG_MI124
	board_str("U-boot MI124\n");
#else
	board_str("U-boot DB120\n");
#endif
	return 0;
}

