
#include "dvlled_mod.h"

#include "drivers/char/ralink_gpio.h"
#include "include/asm-mips/rt2880/surfboardint.h"

struct dvlled_entry global_leds[] = 
{
	{ LEDNAME_WPS_BUTTON, TYPE_LED,  14,  0, 1 },
	{ LEDNAME_PLC_MODULE, TYPE_LED,  11,  0, 1 },
	
	// We fake the HomePlug LEDs until we have a prototype of the device.
	{ LEDNAME_PL_LINK_ACT, TYPE_LED, -1, -1, 0 },
	{ LEDNAME_CL_LINK_ACT, TYPE_LED, -1, -1, 0 },
	
	{ "", TYPE_NONE, 0, 0, 0 }
};

#define GPIO_DIR_OUT 0
#define GPIO_DIR_IN  1

static void dvl_gpio_line_config(int line, int direction)
{
	unsigned int tmp;

	// polarity
	tmp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIOPOL));
	tmp &= ~(unsigned)(1 << line);
	*(volatile u32 *)(RALINK_REG_PIOPOL) = cpu_to_le32(tmp);
	
	// direction
	tmp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIODIR));
	if (direction == GPIO_DIR_OUT)
		tmp |= (1 << line);
	else if (direction == GPIO_DIR_IN)
		tmp &= ~(unsigned)(1 << line);
	*(volatile u32 *)(RALINK_REG_PIODIR) = cpu_to_le32(tmp);
}

static void dvl_gpio_line_set(int line, int value)
{
	unsigned int tmp;
	
	tmp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIODATA));
	if (value)
		tmp |= (1 << line);
	else
		tmp &= ~(1 << line);
	*(volatile u32 *)(RALINK_REG_PIODATA) = cpu_to_le32(tmp);
}

//
//
//

void dvl_led_config_out(int line)
{
	dvl_gpio_line_config(line, GPIO_DIR_OUT);
}

void dvl_led_set(int line, int value)
{
	dvl_gpio_line_set(line, value);
}

void dvl_led_probe(struct platform_device *pdev)
{
}

void dvl_led_remove(struct platform_device *pdev)
{
}

void dvl_led_init(void)
{
	unsigned int gpiomode;
	
	gpiomode = le32_to_cpu(*(volatile u32 *)(RALINK_REG_GPIOMODE));
	gpiomode &= ~0x1C;
	gpiomode |= RALINK_GPIOMODE_DFT;
	*(volatile u32 *)(RALINK_REG_GPIOMODE) = cpu_to_le32(gpiomode);
}

