
#include "dvlbutton_mod.h"

#include "drivers/char/ralink_gpio.h"
#include "include/asm-mips/rt2880/surfboardint.h"

struct dvlbutton_entry global_buttons[] = 
{
	{ BUTTONNAME_RESET_FACTORY, TYPE_BUTTON_SHORTLONG, DVLBUTTON_RESET,       DVLBUTTON_FACTORYDEFAULT, 10, SURFBOARDINT_GPIO, 1 },
	{ BUTTONNAME_PAIRING,       TYPE_BUTTON,           DVLBUTTON_WPS,         DVLBUTTON_NONE,            0, SURFBOARDINT_GPIO, 1 },
	{ BUTTONNAME_WIFI_ON_OFF,   TYPE_BUTTON,           DVLBUTTON_WIFI_ON_OFF, DVLBUTTON_NONE,            8, SURFBOARDINT_GPIO, 1 },
	
	// This board does not have coax, so we provide a fake switch which always states that PL is active.
	{ BUTTONNAME_PL_CL,         TYPE_SWITCH,           DVLBUTTON_DLAN_PL,     DVLBUTTON_DLAN_PL,        -1, -1, 0 },
	
	{ "", TYPE_NONE, 0, 0, 0, 0, 0 }
};

#define GPIO_DIR_OUT 0
#define GPIO_DIR_IN  1

static void dvl_gpio_line_config(int line, int direction)
{
	unsigned int tmp;

	// edge
	tmp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIORENA));
	tmp |= (1 << line);
	*(volatile u32 *)(RALINK_REG_PIORENA) = cpu_to_le32(tmp);
	tmp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIOFENA));
	tmp |= (1 << line);
	*(volatile u32 *)(RALINK_REG_PIOFENA) = cpu_to_le32(tmp);
	
	// polarity
	tmp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIOPOL));
	tmp &= ~(unsigned)(1 << line);
	*(volatile u32 *)(RALINK_REG_PIOPOL) = cpu_to_le32(tmp);
	
	// direction
	tmp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIODIR));
	if (direction == GPIO_DIR_OUT)
		tmp |= (1 << line);
	else if (direction == GPIO_DIR_IN)
		tmp &= ~(unsigned)(1 << line);
	*(volatile u32 *)(RALINK_REG_PIODIR) = cpu_to_le32(tmp);
}

void dvl_gpio_line_get(int line, int *value)
{
	unsigned int tmp, tmp1, tmp2;
	
	tmp1 =   le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIODATA));
	tmp1 &= ~le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIOINT));
	tmp2 =   le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIOEDGE));
	tmp2 &=  le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIOINT));
	tmp = tmp1 | tmp2;
	tmp &= (1 << line);
	*value = (int) (tmp >> line);
}

#if 0
void dvl_gpio_line_set(int line, int value)
{
	unsigned int tmp;
	
	tmp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIODATA));
	if (value)
		tmp |= (1 << line);
	else
		tmp &= ~(1 << line);
	*(volatile u32 *)(RALINK_REG_PIODATA) = cpu_to_le32(tmp);
}
#endif

//
//
//

void dvl_gpio_line_config_in(int line)
{
	dvl_gpio_line_config(line, GPIO_DIR_IN);
}

void dvl_gpio_change_get(int irq, int *button, int *change)
{
	int g;
	unsigned int irqs = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIOINT));
	unsigned int edge = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIOEDGE));

	*button = -1;
	
	for (g = 0; g < 32; g++, irqs >>= 1, edge >>= 1)
	{
		if ((irqs & 1) != 0)
		{
			struct dvlbutton_entry *b;
			int i;
			
			for (b = global_buttons, i = 0; b->type != TYPE_NONE; b++, i++)
			{
				if (b->gpio == g)
				{
					*button = i;
				}
			}
			
			*change = edge & 1;
		}
	}
}

void dvl_gpio_clear(void)
{
	*(volatile u32 *)(RALINK_REG_PIOINT)  = cpu_to_le32(0x00FFFFFF);
	*(volatile u32 *)(RALINK_REG_PIOEDGE) = cpu_to_le32(0x00FFFFFF);
}

void dvl_gpio_init(void)
{
	unsigned int gpiomode;
	
	gpiomode = le32_to_cpu(*(volatile u32 *)(RALINK_REG_GPIOMODE));
	gpiomode &= ~0x1C;
	gpiomode |= RALINK_GPIOMODE_DFT;
	*(volatile u32 *)(RALINK_REG_GPIOMODE) = cpu_to_le32(gpiomode);
}

