/*******************************************************************************
						countries.c Copyright 2002 Silicon Laboratories

This file contains the coefficents for tones of different countries.
************************************************************************************/

#include "dual_io.h"
//#include "stdlib.h"
#include "dual.h"





tone_struct UKcongest = 
 {
			{0x79C0/2, 0x0140, 0, 0x07,0x08, 0x10,0x68},{0x8000/2, 0x0000, 0, 0x07,0x08, 0x10,0x68},NULL
		};

tone_struct UKring = 

{

	
			{0x79C0/2, 0x00A0, 0, 0x0C,0x80, 0x3E,0x80},{0x7810/2, 0x00B5, 0, 0x0C,0x80, 0x3E,0x80},NULL
	
};
/*********************************************************************/
//uk part2
Oscillator UKring2 = { 0x7f00/2, 0x01eb,0,0x0C,0x80, 0x3E,0x80, NULL };

/*typedef struct {
	unsigned short coeff;
	unsigned short x;
	unsigned short y;
	unsigned char on_hi_byte;
	unsigned char on_low_byte;
	unsigned char off_hi_byte;
	unsigned char off_low_byte;
	oscPtr next;
} Oscillator;*/

Oscillator worldSingleTones [NUMSPECIALTONE] [NUMCOUNTRY] =
{
	{//************PULSE***************
//USA
{ 0, 0 , 0 , 0 , 0 , 0 , 0, NULL},	
//JApan
{ 0, 0 , 0 , 0 , 0 , 0 , 0, NULL},	
//Taiwan
{ 0, 0 , 0 , 0 , 0 , 0 , 0, NULL},
//austri
{ 0x3100, 0x0c93,/*PLSD*/0x7fff, 0x03,0x20, 0x07,0xD0, NULL },
//belgium
{ 0x0000, 0x10d5,/*PLSD*/0x7fff, 0x03,0x20, 0x07,0xD0, NULL },
//bulgaria
{ 0x0000, 0x12d2,/*PLSD*/0x7fff, 0x01,0xE0, 0x03,0x70, NULL },
//czech
{ 0x0000, 0x0977,/*PLSD*/0x7fff, 0x03,0xC0, 0x03,0xC0, NULL },
//denmark
//12000 -5 ? ? 200
{ 0, 0 , 0 , 0 , 0 , 0 , 0, NULL},
//finland
{ 0x0000, 0x12d2,/*PLSD*/0x7fff, 0x04,0xB0, 0x0C,0x80, NULL },
//france
{ 0x3100, 0x0b3f,/*PLSD*/0x7fff, 0x03,0xE8, 0x06,0x40, NULL },
//greece
{ 0x0000, 0x10d5,/*PLSD*/0x7fff, 0x01,0x90, 0x02,0xD0, NULL },
//hungary
//12000 -5 ? ? 200
{ 0, 0 , 0 , 0 , 0 , 0 , 0, NULL},
//iceland,
{ 0x3190, 0x04ff,/*PLSD*/0x7fff, 0x04,0x60, 0x04,0x60, NULL },
//italy
{ 0x3100, 0x0c93,/*PLSD*/0x7fff, 0x03,0xE8, 0x06,0x40, NULL },
//luxembourg Z?
{ 0x0000, 0x960c,/*PLSD*/0x7fff, 0x03,0x20, 0x03,0x20, NULL },
//netherlands?
//50
{ 0, 0 , 0 , 0 , 0 , 0 , 0, NULL},
//norway
//16000 -10 ?? 200 
{ 0, 0 , 0 , 0 , 0 , 0 , 0, NULL},
//poland
{ 0x0000, 0x12d2,/*PLSD*/0x7fff, 0x03,0xE8, 0x0C,0x80, NULL },
//portugal
{ 0x3100, 0x0b3f,/*PLSD*/0x7fff, 0x06,0x40, 0x06,0x40, NULL },
//slovakia
//16000 -2 ? ? 200
{ 0, 0 , 0 , 0 , 0 , 0 , 0, NULL},
//sweden
//12000 -7 ? ? 200
{ 0, 0 , 0 , 0 , 0 , 0 , 0, NULL},
//switxerlan
{ 0x3100, 0x0506,/*PLSD*/0x7fff, 0x02,0x30, 0x03,0x2, NULL },
//UK
{ 0, 0 , 0 , 0 , 0 , 0 , 0, NULL}

	},

	{//**********RING*****************
	//Ringing
//USA
	{ 0x7f00, 0x013d , 0 , 0x3E , 0x80 , 0x7D , 0x00, NULL},
//japan
{ 0, 0 , 0 , 0 , 0 , 0 , 0, NULL},
//taiwan
{ 0, 0 , 0 , 0 , 0 , 0 , 0, NULL},
//Austria
{ 0x79c0, 0x0479,0,0x1F,0x40, 0x9C,0x40, NULL },
//belgium
{ 0x7e70, 0x01a9,0,0x1F,0x40, 0x5D,0xC0, NULL },
//bulgaria
{ 0x7dc0, 0x01ff,0,0x1F,0x40, 0x7D,0x00, NULL },
//czech
{ 0x7dc0, 0x01ff,0,0x1F,0x40, 0x7D,0x00, NULL },
//denmark
{ 0x7e70, 0x01a9,0,0x17,0x70, 0xEA,0x60, NULL },
//finland
{ 0x7e70, 0x01a9,0,0x1F,0x40, 0x7D,0x00, NULL },
//france
{ 0x79c0, 0x035b,0,0x2E,0xE0, 0x6D,0x60, NULL },
//hungary
{ 0x7e70, 0x01d8,0,0x27,0x10, 0x75,0x30, NULL },
//iceland
{ 0x7e70, 0x01a9,0,0x25,0x80, 0x92,0xE0, NULL },
//italy
{ 0x7dc0, 0x01ff,0,0x1F,0x40, 0x7D,0x00, NULL },
//luxembourg
{ 0x7e70, 0x0237,0,0x1F,0x40, 0x7D,0x00, NULL },
//netherlands
{ 0x7e70, 0x01a9,0,0x1F,0x40, 0x7D,0x00, NULL },
//norway
{ 0x7e70, 0x01a9,0,0x1F,0x40, 0x7D,0x00, NULL },
//poland
{ 0x7e70, 0x01a9,0,0x1F,0x40, 0x7D,0x00, NULL },
//portugal
{ 0x7f00, 0x0154,0,0x1F,0x40, 0x9C,0x40, NULL },
//slovakia - voltage too high?
{ 0x7e70, 0x01a9,0,0x1F,0x40, 0x7D,0x00, NULL },
//spain,
{ 0x7e70, 0x0266,0,0x2E,0xE0, 0x5D,0xC0, NULL },
//sweden
{ 0x7cf0, 0x035f,0,0x1F,0x40, 0x9C,0x40, NULL },
//switzer
{ 0x7cf0, 0x0255,0,0x1F,0x40, 0x7D,0x00, NULL },
//uk
{ 0x7f00, 0x01eb,0,0x0C,0x80, 0x06,0x40, &UKring2 }

	
	}


};

/*2 dimensional array of countrys and audible dual tones*/
tone_struct worldTones [NUMCOUNTRY][NUMTONEtype]= /* Country=rows Tone=column */
{ 

	{/*BusySignal USA*/
		{ /* OSC1= 480  OSC2 = 620 .0975 Voltz -18 dBm 8*/
			{0x7700/2,0x0089,0,0x0f,0xa0,0x0f,0xa0},{0x7120/2,0x00b2,0,0x0f,0xa0,0x0f,0xa0},NULL
		},
	/*DialTone USA*/
		{  /* OSC1= 350 Hz OSC2= 440 Hz .0975 Volts -18 dBm */
			{0x7b30/2,0x0063,0,0,0,0,0},{0x7870/2,0x007d,0,0,0,0,0},NULL
		},



	/*ReorderTone USA*/
		{	/* OSC1= 480 Hz OSC2 = 620 .0975 Volts -18 dBm */
			{0x7700/2,0x0089,0,0x09,0x60,0x06,0x40},{0x7120/2,0x00b2,0,0x09,0x60,0x06,0x40},NULL
		},
	/*CongestionTone USA*/
		{ /* OSC1= 480 Hz OSC2 = 620 .0975 Volts -18 dBM */
			{0x7700/2,0x0089,0,0x06,0x40,0x09,0x60},{0x7120/2,0x00b2,0,0x06,0x40,0x09,0x60},NULL
		},
	/*Undef (no such number)*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},
	/*Ringback USA*/
		{ /* OSC1 = 440 Hz OSC2 = 480 .0975 Volts -18 dBm */
			{0x7870/2,0x007d,0,0x3e,0x80,0x7d,0x00},{0x7700/2,0x0089,0,0x3e,0x80,0x7d,0x00},NULL
		}
	},

	{/*BusyJapan*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0},NULL
		},
	/*JapanDialTone*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0,0,0,0},{0,0,0,0,0,0,0},NULL
		},
	/*Undef (reorder)*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},
	/*Undef (congestion)*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},
	/*Undef (no such number)*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},
	/*Ringback JAPAN*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x1f,0x40,0x3e,0x80},{0x7940/2,0x00f2,0,0x1f,0x40,0x3e,0x80},NULL
		}
	},

	{
	/* (Taiwan busy)*/
		{
			{0x7870/2, 0x002C, 0, 0x0F,0xA0, 0x0F,0xA0},{0x7700/2, 0x0030, 0, 0x0F,0xA0, 0x0F,0xA0},NULL
		},
	/* (Taiwan dial tone)*/
		{
			{0x7B30/2, 0x007D, 0, 0x00,0x00, 0x00,0x00},{0x7870/2, 0x009E, 0, 0x00,0x00, 0x00,0x00},NULL
		},
	/* (Taiwan reorder)*/
		{
			{0x7870/2, 0x002C, 0, 0x07,0xD0, 0x07,0xD0},{0x7700/2, 0x0030, 0, 0x07,0xD0, 0x07,0xD0},NULL
		},
	/*Undef (Taiwan congestion)*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},
	/*Undef (Taiwan no such number)*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},
	/* (Taiwan ringback)*/
		{
			{0x7870/2, 0x004F, 0, 0x1F,0x40, 0x3E,0x80},{0x7700/2, 0x0056, 0, 0x1F,0x40, 0x3E,0x80},NULL
		}
	},
	{
//Austria
//
//Dialtone
// busyTone
		{
			{0x79C0/2, 0x005A, 0, 0x0F,0xA0, 0x0F,0xA0},{0x76A0/2, 0x006F, 0, 0x0F,0xA0, 0x0F,0xA0},NULL
		},



// dialTone
		{
			{0x79C0/2, 0x0050, 0, 0x00,0x00, 0x00,0x00},{0x76A0/2, 0x0063, 0, 0x00,0x00, 0x00,0x00},NULL
		},


 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},
 
// congestionTone
		{
			{0x79C0/2, 0x0032, 0, 0x06,0x40, 0x06,0x40},{0x7810/2, 0x0039, 0, 0x06,0x40, 0x06,0x40},NULL
		},

/*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},
 
// ringTone
		{
			{0x79C0/2, 0x0032, 0, 0x1F,0x40, 0x9C,0x40},{0x76A0/2, 0x003E, 0, 0x1F,0x40, 0x9C,0x40},NULL
		}
 

	},
	{
//Belgium
// busyTone
		{
			{0x7920/2, 0x005E, 0, 0x0F,0xA0, 0x0F,0xA0},{0x77F0/2, 0x0067, 0, 0x0F,0xA0, 0x0F,0xA0},NULL
		},
// dialTone
		{
			{0x7920/2, 0x0096, 0, 0x00,0x00, 0x00,0x00},{0x77F0/2, 0x00A3, 0, 0x00,0x00, 0x00,0x00},NULL
		},

 
 



 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},
 
 // congestionTone
		{
			{0x7920/2, 0x005E, 0, 0x05,0x38, 0x05,0x38},{0x77F0/2, 0x0067, 0, 0x05,0x38, 0x05,0x38},NULL
		},


 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},
 
 


// ringTone
		{
			{0x7920/2, 0x005E, 0, 0x1F,0x40, 0x5D,0xC0},{0x77F0/2, 0x0067, 0, 0x1F,0x40, 0x5D,0xC0},NULL
		}

 
	},
	{
//Bulgaria
// busyTone
		{
			{0x7A50/2, 0x0099, 0, 0x06,0x40, 0x0F,0xA0},{0x7760/2, 0x00BD, 0, 0x06,0x40, 0x0F,0xA0},NULL
		},

 
 

// dialTone
	{
			{0x7A50/2, 0x0099, 0, 0x00,0x00, 0x00,0x00},{0x7760/2, 0x00BD, 0, 0x00,0x00, 0x00,0x00},NULL
		},

 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},
 



// congestionTone
		{
			{0x79C0/2, 0x00A0, 0, 0x07,0xD0, 0x07,0xD0},{0x7810/2, 0x00B5, 0, 0x07,0xD0, 0x07,0xD0},NULL
		},
/*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},
 
// ringTone
		{
			{0x7A50/2, 0x0099, 0, 0x1F,0x40, 0x7D,0x00},{0x7760/2, 0x00BD, 0, 0x1F,0x40, 0x7D,0x00},NULL
		}
 
 

 
 
	},
	{
//Czech Republic
// busyTone
		{
			{0x7AA0/2, 0x0094, 0, 0x0A,0x50, 0x0A,0x50},{0x7640/2, 0x00CA, 0, 0x0A,0x50, 0x0A,0x50},NULL
		},

 
 
// dialTone
		{
			{0x7AA0/2, 0x0094, 0, 0x00,0x00, 0x00,0x00},{0x7640/2, 0x00CA, 0, 0x00,0x00, 0x00,0x00},NULL
		},

 
 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},




// congestionTone
		{
			{0x79C0/2, 0x00A0, 0, 0x05,0x28, 0x05,0x28},{0x7810/2, 0x00B5, 0, 0x05,0x28, 0x05,0x28},NULL
		},	
 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},
 


// ringTone
		{
			{0x7AA0/2, 0x0094, 0, 0x1F,0x40, 0x7D,0x00},{0x7640/2, 0x00CA, 0, 0x1F,0x40, 0x7D,0x00},NULL
		}
 
	},
	{
//Denmark
// busyTone
		{
			{0x79C0/2, 0x00A0, 0, 0x0E,0x10, 0x0E,0x10},{0x7810/2, 0x00B5, 0, 0x0E,0x10, 0x0E,0x10},NULL
		},

// dialTone
		{
			{0x79C0/2, 0x00A0, 0, 0x00,0x00, 0x00,0x00},{0x7810/2, 0x00B5, 0, 0x00,0x00, 0x00,0x00},NULL
		},

 
 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},


// congestionTone
		{
			{0x79C0/2, 0x00A0, 0, 0x07,0xD0, 0x07,0xD0},{0x7810/2, 0x00B5, 0, 0x07,0xD0, 0x07,0xD0},NULL
		},
 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},
 
// ringTone
		
		{
			{0x79C0/2, 0x00A0, 0, 0x1F,0x40, 0x7D,0x00},{0x7810/2, 0x00B5, 0, 0x1F,0x40, 0x7D,0x00},NULL
		}

 


	},
	{
//Finland
// busyTone
	{
			{0x79C0/2, 0x00A0, 0, 0x09,0x60, 0x09,0x60},{0x7810/2, 0x00B5, 0, 0x09,0x60, 0x09,0x60},NULL
		},

// dialTone
		{
			{0x79C0/2, 0x00A0, 0, 0x00,0x00, 0x00,0x00},{0x7810/2, 0x00B5, 0, 0x00,0x00, 0x00,0x00},NULL
		},

  /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0},NULL   /*same as BusyJapan */
		},
 



// congestionTone
		{
			{0x79C0/2, 0x00A0, 0, 0x06,0x40, 0x06,0x40},{0x7810/2, 0x00B5, 0, 0x06,0x40, 0x06,0x40},NULL
		},
 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0},NULL   /*same as BusyJapan */
		},
// ringTone
		{
			{0x79C0/2, 0x00A0, 0, 0x1F,0x40, 0x7D,0x00},{0x7810/2, 0x00B5, 0, 0x1F,0x40, 0x7D,0x00},NULL
		}
	},
	{
//France
// busyTone
		{
			{0x78F0/2, 0x00AB, 0, 0x0F,0xA0, 0x0F,0xA0},{0x77F0/2, 0x00B7, 0, 0x0F,0xA0, 0x0F,0xA0},NULL
		},
// dialTone
		{
			{0x78F0/2, 0x00AB, 0, 0x00,0x00, 0x00,0x00},{0x77F0/2, 0x00B7, 0, 0x00,0x00, 0x00,0x00},NULL
		},

 
 

  /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},
 


 

// congestionTone
		{
			{0x78F0/2, 0x00AB, 0, 0x0F,0xA0, 0x0F,0xA0},{0x77F0/2, 0x00B7, 0, 0x0F,0xA0, 0x0F,0xA0},NULL
		},
 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},
 
// ringTone
		{
			{0x78F0/2, 0x00AB, 0, 0x2E,0xE0, 0x6D,0x60},{0x77F0/2, 0x00B7, 0, 0x2E,0xE0, 0x6D,0x60},NULL
		}

 
	},
	{
//Hungary
// busyTone
		{
			{0x7A80/2, 0x0096, 0, 0x09,0x60, 0x09,0x60},{0x7730/2, 0x00BF, 0, 0x09,0x60, 0x09,0x60},NULL
		},

 
 
// dialTone
	{
			{0x7A80/2, 0x0096, 0, 0x00,0x00, 0x00,0x00},{0x7730/2, 0x00BF, 0, 0x00,0x00, 0x00,0x00},NULL
		},

 
 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},


// congestionTone
		{
			{0x7A80/2, 0x0096, 0, 0x09,0x60, 0x09,0x60},{0x7730/2, 0x00BF, 0, 0x09,0x60, 0x09,0x60},NULL
		},
/*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},
 // ringTone
		{
			{0x7A80/2, 0x0096, 0, 0x27,0x10, 0x75,0x30},{0x7730/2, 0x00BF, 0, 0x27,0x10, 0x75,0x30},NULL
		}
	},
	{
//Iceland
// busyTone
		{
			{0x79C0/2, 0x00A0, 0, 0x07,0xD0, 0x07,0xD0},{0x7810/2, 0x00B5, 0, 0x07,0xD0, 0x07,0xD0},NULL
		},

 
 

// dialTone
		{
			{0x79C0/2, 0x00A0, 0, 0x00,0x00, 0x00,0x00},{0x7810/2, 0x00B5, 0, 0x00,0x00, 0x00,0x00},NULL
		},

 
 

/*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0},NULL   /*same as BusyJapan */
		},


// congestionTone
		{
			{0x79C0/2, 0x00A0, 0, 0x07,0xD0, 0x07,0xD0},{0x7810/2, 0x00B5, 0, 0x07,0xD0, 0x07,0xD0},NULL
		},
/*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0},NULL   /*same as BusyJapan */
		},
// ringTone
	{
			{0x79C0/2, 0x00A0, 0, 0x25,0x80, 0x92,0xE0},{0x7810/2, 0x00B5, 0, 0x25,0x80, 0x92,0xE0},NULL
		}

 
 

	},
	{
//Italy
// busyTone
		{
			{0x7970/2, 0x00A4, 0, 0x0F,0xA0, 0x0F,0xA0},{0x7870/2, 0x00B1, 0, 0x0F,0xA0, 0x0F,0xA0},NULL
		},

 
 
// dialTone
		{
			{0x7970/2, 0x00A4, 0, 0x00,0x00, 0x00,0x00},{0x7870/2, 0x00B1, 0, 0x00,0x00, 0x00,0x00},NULL
		},

 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0},NULL   /*same as BusyJapan */
		},
 




// congestionTone
	{
			{0x7970/2, 0x00A4, 0, 0x06,0x40, 0x06,0x40},{0x7870/2, 0x00B1, 0, 0x06,0x40, 0x06,0x40},NULL
		},
/*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},
// ringTone
		{
			{0x7970/2, 0x00A4, 0, 0x1F,0x40, 0x7D,0x00},{0x7870/2, 0x00B1, 0, 0x1F,0x40, 0x7D,0x00},NULL
		}

 
 

 
	},
	{
//Luxembourg
// busyTone
		{
			{0x7A50/2, 0x0099, 0, 0x0F,0x00, 0x0F,0x00},{0x76A0/2, 0x00C6, 0, 0x0F,0x00, 0x0F,0x00},NULL
		},

 
 
// dialTone
	{
			{0x7A50/2, 0x0099, 0, 0x00,0x00, 0x00,0x00},{0x76A0/2, 0x00C6, 0, 0x00,0x00, 0x00,0x00},NULL
		},

 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},
 




// congestionTone
		{
			{0x7A50/2, 0x0099, 0, 0x07,0x80, 0x07,0x80},{0x76A0/2, 0x00C6, 0, 0x07,0x80, 0x07,0x80},NULL
		},
/*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},
// ringTone
		{
			{0x7A50/2, 0x0099, 0, 0x1F,0x40, 0x7D,0x00},{0x76A0/2, 0x00C6, 0, 0x1F,0x40, 0x7D,0x00},NULL
		}

 
 

 
	},
	{
//Netherlands
// busyTone
		{
			{0x7B70/2, 0x0088, 0, 0x0F,0xA0, 0x0F,0xA0},{0x7440/2, 0x00DE, 0, 0x0F,0xA0, 0x0F,0xA0},NULL
		},

 
// dialTone
		{
			{0x7B70/2, 0x0088, 0, 0x00,0x00, 0x00,0x00},{0x7440/2, 0x00DE, 0, 0x00,0x00, 0x00,0x00},NULL
		},

 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},

// congestionTone
		{
			{0x7B70/2, 0x0088, 0, 0x06,0x40, 0x06,0x40},{0x7440/2, 0x00DE, 0, 0x06,0x40, 0x06,0x40},NULL
		},
/*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},
// ringTone
		{
			{0x7B70/2, 0x0088, 0, 0x1F,0x40, 0x7D,0x00},{0x7440/2, 0x00DE, 0, 0x1F,0x40, 0x7D,0x00},NULL
		}

 
 
	},
	{
//Norway
// busyTone
		{
			{0x7970/2, 0x00A4, 0, 0x0F,0xA0, 0x0F,0xA0},{0x7870/2, 0x00B1, 0, 0x0F,0xA0, 0x0F,0xA0},NULL
		},

// dialTone
	{
			{0x7970/2, 0x00A4, 0, 0x00,0x00, 0x00,0x00},{0x7870/2, 0x00B1, 0, 0x00,0x00, 0x00,0x00},NULL
		},

 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},

// congestionTone
		{
			{0x7970/2, 0x00A4, 0, 0x06,0x40, 0x06,0x40},{0x7870/2, 0x00B1, 0, 0x06,0x40, 0x06,0x40},NULL
		},
/*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},
// ringTone
		{
			{0x7970/2, 0x00A4, 0, 0x1F,0x40, 0x7D,0x00},{0x7870/2, 0x00B1, 0, 0x1F,0x40, 0x7D,0x00},NULL
		}

	},
	{
//Poland
// busyTone
		{
			{0x7AF0/2, 0x0090, 0, 0x0F,0xA0, 0x0F,0xA0},{0x7810/2, 0x00B5, 0, 0x0F,0xA0, 0x0F,0xA0},NULL
		},

 
 
// dialTone
		{
			{0x7AF0/2, 0x0090, 0, 0x00,0x00, 0x00,0x00},{0x7810/2, 0x00B5, 0, 0x00,0x00, 0x00,0x00},NULL
		},

 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},

// congestionTone
	{
			{0x7AF0/2, 0x0090, 0, 0x0F,0xA0, 0x0F,0xA0},{0x7810/2, 0x00B5, 0, 0x0F,0xA0, 0x0F,0xA0},NULL
		},
/*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},
// ringTone
		{
			{0x7AF0/2, 0x0090, 0, 0x1F,0x40, 0x7D,0x00},{0x7810/2, 0x00B5, 0, 0x1F,0x40, 0x7D,0x00},NULL
		}

 
 
 
	},

	{
//Portugal
// busyTone
	{
			{0x7C70/2, 0x0078, 0, 0x0F,0xA0, 0x0F,0xA0},{0x7810/2, 0x00B5, 0, 0x0F,0xA0, 0x0F,0xA0},NULL
		},

 
 

// dialTone
		{
			{0x7C70/2, 0x0078, 0, 0x00,0x00, 0x00,0x00},{0x7810/2, 0x00B5, 0, 0x00,0x00, 0x00,0x00},NULL
		},

 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}   ,NULL/*same as BusyJapan */
		},

// congestionTone
	{
			{0x7C70/2, 0x0078, 0, 0x06,0x40, 0x06,0x40},{0x7810/2, 0x00B5, 0, 0x06,0x40, 0x06,0x40},NULL
		},
/*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0},NULL   /*same as BusyJapan */
		},
// ringTone
		{
			{0x7C70/2, 0x0078, 0, 0x1F,0x40, 0x9C,0x40},{0x7810/2, 0x00B5, 0, 0x1F,0x40, 0x9C,0x40},NULL
		}


 
	},
	{
//Slovakia


// busyTone
		{
			{0x7990/2, 0x00A3, 0, 0x0A,0x50, 0x0A,0x50},{0x7840/2, 0x00B3, 0, 0x0A,0x50, 0x0A,0x50},NULL
		},

// dialTone
		{
			{0x7990/2, 0x00A3, 0, 0x00,0x00, 0x00,0x00},{0x7840/2, 0x00B3, 0, 0x00,0x00, 0x00,0x00},NULL
		},

 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},

// congestionTone
		{
			{0x7990/2, 0x00A3, 0, 0x05,0x28, 0x05,0x28},{0x7840/2, 0x00B3, 0, 0x05,0x28, 0x05,0x28},NULL
		},
/*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}  ,NULL /*same as BusyJapan */
		},
 // ringTone
		{
			{0x7990/2, 0x00A3, 0, 0x1F,0x40, 0x7D,0x00},{0x7840/2, 0x00B3, 0, 0x1F,0x40, 0x7D,0x00},NULL
		}

 
 
	},
	{
//Spain

// busyTone
		{
			{0x7970/2, 0x00A4, 0, 0x06,0x40, 0x06,0x40},{0x7870/2, 0x00B1, 0, 0x06,0x40, 0x06,0x40},NULL
		},

// dialTone
		{
			{0x7970/2, 0x00A4, 0, 0x00,0x00, 0x00,0x00},{0x7870/2, 0x00B1, 0, 0x00,0x00, 0x00,0x00},NULL
		},

 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0},NULL   /*same as BusyJapan */
		},
 
//?

// congestionTone
		{
			{0x7970/2, 0x00A4, 0, 0x12,0xC0, 0x1F,0x40},{0x7870/2, 0x00B1, 0, 0x12,0xC0, 0x1F,0x40},NULL
		},
/*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},
// ringTone
		{
			{0x7970/2, 0x00A4, 0, 0x2E,0xE0, 0x5D,0xC0},{0x7870/2, 0x00B1, 0, 0x2E,0xE0, 0x5D,0xC0},NULL
		}

 
	},
	{
//Sweden
// busyTone
		{
			{0x79C0/2, 0x00A0, 0, 0x07,0xD0, 0x07,0xD0},{0x7810/2, 0x00B5, 0, 0x07,0xD0, 0x07,0xD0},NULL
		},
// dialTone
{
			{0x79C0/2, 0x00A0, 0, 0x00,0x00, 0x00,0x00},{0x7810/2, 0x00B5, 0, 0x00,0x00, 0x00,0x00},NULL
		},

	

 
 


 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0}   ,NULL/*same as BusyJapan */
		},
 



 
 

// congestionTone
		{
			{0x79C0/2, 0x00A0, 0, 0x07,0xD0, 0x17,0x70},{0x7810/2, 0x00B5, 0, 0x07,0xD0, 0x17,0x70},NULL
		},

 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},
 



// ringTone
		{
			{0x79C0/2, 0x00A0, 0, 0x1F,0x40, 0x9C,0x40},{0x7810/2, 0x00B5, 0, 0x1F,0x40, 0x9C,0x40},NULL
		}

 
	},
	{
//Switzerland
// busyTone
		{
			{0x79C0/2, 0x00A0, 0, 0x0F,0xA0, 0x0F,0xA0},{0x7810/2, 0x00B5, 0, 0x0F,0xA0, 0x0F,0xA0},NULL
		},
// dialTone

		{
			{0x79C0/2, 0x0040, 0, 0x00,0x00, 0x00,0x00},{0x7810/2, 0x0048, 0, 0x00,0x00, 0x00,0x00},NULL
		},
 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0},NULL   /*same as BusyJapan */
		},

// congestionTone
		{
			{0x79C0/2, 0x00A0, 0, 0x06,0x40, 0x06,0x40},{0x7810/2, 0x00B5, 0, 0x06,0x40, 0x06,0x40},NULL
		},
/*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},
// ringTone
		{
			{0x79C0/2, 0x00A0, 0, 0x1F,0x40, 0x7D,0x00},{0x7810/2, 0x00B5, 0, 0x1F,0x40, 0x7D,0x00},NULL
		}


	},
	{
//UK
//busy

// busy
		{
			{0x79C0/2, 0x00A0, 0, 0x0B,0xB8, 0x0B,0xB8},{0x8000, 0x0000, 0, 0x0B,0xB8, 0x0B,0xB8},NULL
		},

 
 
//dial

// dial
		{
			{0x7B30/2, 0x008C, 0, 0x00,0x00, 0x00,0x00},{0x7870/2, 0x00B1, 0, 0x00,0x00, 0x00,0x00},NULL
		},

 /*Undef*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0} ,NULL  /*same as BusyJapan */
		},
 
//congest (complex)

// congest
		{
			{0x79C0/2, 0x00A0, 0, 0x0C,0x80, 0x0A,0xF0},{0x8000, 0x0000, 0, 0x0C,0x80, 0x0A,0xF0},&UKcongest
		},
 /*Undefined*/
		{ /* OSC1 = 400 Hz OSC2 = 435 .0975 Volts -18 dBm */
			{0x79c0/2,0x00e9,0,0x0f,0xa0,0x0f,0xa0},{0,0,0,0,0,0,0},NULL   /*same as BusyJapan */
		},
 
//ring (complex)

// ring
		{
			{0x79C0/2, 0x00A0, 0, 0x0C,0x80, 0x06,0x40},{0x7810/2, 0x00B5, 0, 0x0C,0x80, 0x06,0x40},&UKring
		}

 
 

	}
	


};


